package view;

import model.GuessMyWordModel;

public class GuessController {

    private final GuessMyWordModel model;
    private final GuessView view;

    public GuessController(GuessMyWordModel model, GuessView view) {
        this.model = model;
        this.view = view;
    }

    void handleResetEvent() {
        model.reset();
        view.updateOnReset();
    }

    void handleGuessEvent() {
        String guessString = view.getGuessInput();
        if (guessString.length() > 0) {
            char guess = guessString.charAt(0);
            model.handleGuess(guess);

            if (model.isSolved()) {
                view.showAlert("Congratualtions!");
                model.reset();
            }
        }
        view.updateFromModel();
    }
}
